/* eslint-disable react/prop-types */
import { useEffect, useState } from "react";
import { FaHome } from "react-icons/fa";
import { IoHomeOutline } from "react-icons/io5";
import {
  MdKeyboardArrowDown,
  MdKeyboardArrowLeft,
  MdKeyboardArrowRight,
  MdKeyboardArrowUp,
} from "react-icons/md";
import MiniMobileSidebar from "../sidebar/MiniMobileSidebar";
import { useNavigate } from "react-router-dom";
import { useDispatch, useSelector } from "react-redux";
import { casinoListByCategory, defaultSetting, getCasinoProvider } from "../../redux/_reducers/_reducers";
import { toast } from "react-toastify";
import { IoIosArrowForward } from "react-icons/io";
import MiniGamesSidebar from "../sidebar/MiniGamesSidebar";
import { AiOutlineLoading3Quarters } from "react-icons/ai";
import MiniCasinoProvider from "../sidebar/MiniCasinoProvider";

const AppSidebar = ({ isSidebarClose }) => {
  const [isMobile, setIsMobile] = useState(false);
  const [openDropdown, setOpenDropdown] = useState(null);
  const [miniSidebar, setMiniSidebar] = useState(false);

  const [casinoProvider, setCasinoProvider] = useState(false);

  const [miniCasino, setMiniCasino] = useState(false);
  const [miniSlots, setMiniSlots] = useState(false);
  const [miniTeenpatti, setMiniTeenpatti] = useState(false);
  const [miniLucky7, setMiniLucky7] = useState(false);
  const [miniDragonTiger, setMiniDragonTiger] = useState(false);
  const [miniBaccarat, setMiniBaccarat] = useState(false);
  const [miniAndarBahar, setMiniAndarBahar] = useState(false);


  const [miniPoker, setMiniPoker] = useState(false);
  const [apiData, setApiData] = useState([]);
  const [isLoading, setIsLoading] = useState(false);


  const [gameList, setGameList] = useState(false);
  const [casinoList, setCasinoList] = useState(false);

  const [casinoGamesList, setCasinoGamesList] = useState(false);
  const [slotGamesList, setSlotGamesList] = useState(false);

  const [tableGamesList, setTableGamesList] = useState(false);
  const [crashGamesList, setCrashGamesList] = useState(false);
  const [fishGamesList, setFishGamesList] = useState(false);
  const [arcadeGamesList, setArcadeGamesList] = useState(false);
  const [lotteryGamesList, setLotteryGamesList] = useState(false);


  const [contactUs, setContactUs] = useState(false);
  const dispatch = useDispatch();
  const { defaultSettingData } = useSelector((state) => state.authentication);

  const navigate = useNavigate();

  const handleGetCasinoListByCategory = async (label) => {
    setIsLoading(true);
    const payload = {
      category: label,
      limit: 1000,
    };

    try {
      const response = await dispatch(casinoListByCategory(payload)).unwrap();
      if (response) {
        setApiData(response);
      } else {
        console.warn("No data found in response:", response);
        setApiData([]);
      }
    } catch (error) {
      console.error("API call failed:", error);
      setApiData([]);
    }
    setIsLoading(false);
  };

  const handleCasino = () => {
    setMiniCasino(!miniCasino);
    if (!miniCasino) {
      handleGetCasinoListByCategory("live-casino");
    }
  };

  const handleCasinoProvider = () => {
    setCasinoProvider(!casinoProvider);
    if (!casinoProvider) {
      dispatch(getCasinoProvider())
    }
  };

  const handleSlots = () => {
    setMiniSlots(!miniSlots);
    if (!miniSlots) {
      handleGetCasinoListByCategory("JiLi");
    }
  };

  const handleTeenpatti = () => {
    setMiniTeenpatti(!miniTeenpatti);
    if (!miniTeenpatti) {
      handleGetCasinoListByCategory("Teenpatti");
    }
  };

  const handleLucky7 = () => {
    setMiniLucky7(!miniLucky7);
    if (!miniLucky7) {
      handleGetCasinoListByCategory("Lucky7");
    }
  };

  const handleDragonTiger = () => {
    setMiniLucky7(!miniDragonTiger);
    if (!miniDragonTiger) {
      handleGetCasinoListByCategory("Dragon Tiger");
    }
  };

  const handleBaccarat = () => {
    setMiniBaccarat(!miniBaccarat);
    if (!miniBaccarat) {
      handleGetCasinoListByCategory("Baccarat");
    }
  };

  const handleAndarBahar = () => {
    setMiniAndarBahar(!miniAndarBahar);
    if (!miniAndarBahar) {
      handleGetCasinoListByCategory("AndarBahar");
    }
  };

  const handlePoker = () => {
    setMiniPoker(!miniPoker);
    if (!miniPoker) {
      handleGetCasinoListByCategory("Poker");
    }
  };

  const handleContantUS = () => {
    setContactUs((prev) => !prev);
    setGameList(false);
  };

  const handleGameList = () => {
    setGameList((prev) => !prev);
    setCasinoGamesList(false);
    setContactUs(false);
  };


  const handleCasinoGames = () => {
    setCasinoGamesList((prev) => !prev);
    setGameList(false);
    setSlotGamesList(false)
    setContactUs(false);
    dispatch(getCasinoProvider())
  };

  const handleSlotGames = () => {
    setSlotGamesList((prev) => !prev);
    setCasinoGamesList(false);
    setGameList(false);
    setContactUs(false);
    dispatch(getCasinoProvider())
  };

  const handleTableGames = () => {
    setTableGamesList((prev) => !prev);
    setSlotGamesList(false);
    setCasinoGamesList(false);
    setGameList(false);
    setContactUs(false);
    dispatch(getCasinoProvider())
  };

  const handleCrashGames = () => {
    setCrashGamesList((prev) => !prev);
    setTableGamesList(false);
    setSlotGamesList(false);
    setCasinoGamesList(false);
    setGameList(false);
    setContactUs(false);
    dispatch(getCasinoProvider())
  };

  const handleFishGames = () => {
    setFishGamesList((prev) => !prev);
    setCrashGamesList(false);
    setTableGamesList(false);
    setSlotGamesList(false);
    setCasinoGamesList(false);
    setGameList(false);
    setContactUs(false);
    dispatch(getCasinoProvider())
  };

  const handleArcadeGames = () => {
    setArcadeGamesList((prev) => !prev);
    setFishGamesList(false);
    setCrashGamesList(false);
    setTableGamesList(false);
    setSlotGamesList(false);
    setCasinoGamesList(false);
    setGameList(false);
    setContactUs(false);
    dispatch(getCasinoProvider())
  };

  const handleLotteryGames = () => {
    setLotteryGamesList((prev) => !prev);
    setArcadeGamesList(false);
    setFishGamesList(false);
    setCrashGamesList(false);
    setTableGamesList(false);
    setSlotGamesList(false);
    setCasinoGamesList(false);
    setGameList(false);
    setContactUs(false);
    dispatch(getCasinoProvider())
  };


  const handleProviderClick = (type, providerName) => {
    window.location.href = `/casino-provider/${type}/${providerName}`;

  }

  const handleCasinoList = (id) => {
    setCasinoList(state => {
      if (state == id) {
        return null
      }
      else {
        return id
      }
    });
    setGameList(false);
    setContactUs(false);
  };

  const toggleDropdown = (id) => {
    setOpenDropdown(openDropdown === id ? null : id);
  };

  useEffect(() => {
    dispatch(defaultSetting());
  }, []);

  useEffect(() => {
    const handleResize = () => {
      setIsMobile(window.innerWidth < 1024);
    };
    handleResize();
    window.addEventListener("resize", handleResize);
    return () => {
      window.removeEventListener("resize", handleResize);
    };
  }, []);

  useEffect(() => {
    document.body.classList.add("sidebar-collapse");
  }, []);

  const handleToggle = () => {
    document.body.classList.toggle("sidebar-collapse");
    if (openDropdown) {
      setOpenDropdown(null);
    }
    if (gameList) {
      setGameList(false);
    }
    if (casinoList) {
      setCasinoList(false);
    }
    if (casinoGamesList) {
      setCasinoGamesList(false);
    }
    if (contactUs) {
      setContactUs(false);
    }
    setMiniSidebar(false);
    setCasinoProvider(false);
  };

  const [providers, setProviders] = useState([]);

  const { getCasinoProviderData } = useSelector(state => state.authentication);
  

  useEffect(() => {
    if (getCasinoProviderData && getCasinoProviderData.length > 0) {
      const updatedProviders = getCasinoProviderData.map((provider) => {
        let imageUrl = "/images/default.png";

        if (provider.provider_name === "AWC") imageUrl = "/assets/dashboard/provider-awcmsg.png";
        else if (provider.provider_name === "BETGAMES") imageUrl = "/assets/dashboard/provider-bg.png";
        else if (provider.provider_name === "CRASH88") imageUrl = "/assets/dashboard/provider-awcmpt.png";
        else if (provider.provider_name === "EZUGI") imageUrl = "/assets/dashboard/provider-evo.png";
        else if (provider.provider_name === "JiLi") imageUrl = "/assets/dashboard/provider-awcmjili.png";
        else if (provider.provider_name === "KINGMIDAS") imageUrl = "/assets/dashboard/provider-awcmkm.png";
        else if (provider.provider_name === "MAC88") imageUrl = "/assets/dashboard/provider-mg.png";
        else if (provider.provider_name === "RG") imageUrl = "/assets/dashboard/provider-awcmsg.png";
        else if (provider.provider_name === "SAP") imageUrl = "/assets/dashboard/provider-wm.png";
        else if (provider.provider_name === "SPRIBE") imageUrl = "/assets/dashboard/provider-jdbaspribe.png";
        else if (provider.provider_name === "SUNO") imageUrl = "/assets/dashboard/provider-awcmladyluck.png";
        return { ...provider, image: imageUrl };
      });
      setProviders(updatedProviders);
    }
  }, [getCasinoProviderData]);



  return (
    <>
      {miniSidebar && (
        <MiniMobileSidebar
          setIsSideBar={setMiniSidebar}
          isSideBar={miniSidebar}
          isSidebarClose={isSidebarClose}
        />
      )}

      {casinoProvider && (
        <MiniCasinoProvider
          setIsSideBar={setCasinoProvider}
          handleProviderClick={handleProviderClick}
          isSideBar={casinoProvider}
          providers={providers}
          isSidebarClose={isSidebarClose}
        />
      )}

      {miniCasino && (
        <MiniGamesSidebar
          setIsSideBar={setMiniCasino}
          setApiData={setApiData}
          apiData={apiData}
          isSideBar={miniCasino}
          isSidebarClose={isSidebarClose}
        />
      )}

      {miniSlots && (
        <MiniGamesSidebar
          setIsSideBar={setMiniSlots}
          setApiData={setApiData}
          apiData={apiData}
          isSideBar={miniSlots}
          isSidebarClose={isSidebarClose}
        />
      )}

      {miniTeenpatti && (
        <MiniGamesSidebar
          setIsSideBar={setMiniTeenpatti}
          setApiData={setApiData}
          apiData={apiData}
          isSideBar={miniTeenpatti}
          isSidebarClose={isSidebarClose}
        />
      )}

      {miniLucky7 && (
        <MiniGamesSidebar
          setIsSideBar={setMiniLucky7}
          setApiData={setApiData}
          apiData={apiData}
          isSideBar={miniLucky7}
          isSidebarClose={isSidebarClose}
        />
      )}

      {miniDragonTiger && (
        <MiniGamesSidebar
          setIsSideBar={setMiniDragonTiger}
          setApiData={setApiData}
          apiData={apiData}
          isSideBar={miniDragonTiger}
          isSidebarClose={isSidebarClose}
        />
      )}

      {miniBaccarat && (
        <MiniGamesSidebar
          setIsSideBar={setMiniBaccarat}
          setApiData={setApiData}
          apiData={apiData}
          isSideBar={miniBaccarat}
          isSidebarClose={isSidebarClose}
        />
      )}

      {miniAndarBahar && (
        <MiniGamesSidebar
          setIsSideBar={setMiniAndarBahar}
          setApiData={setApiData}
          apiData={apiData}
          isSideBar={miniAndarBahar}
          isSidebarClose={isSidebarClose}
        />
      )}

      {miniPoker && (
        <MiniGamesSidebar
          setIsSideBar={setMiniPoker}
          setApiData={setApiData}
          apiData={apiData}
          isSideBar={miniPoker}
          isSidebarClose={isSidebarClose}
        />
      )}

      {/* Desktop Sidebar */}
      <div className="hidden lg:block  max-h-[98vh] scrollbar-hide overflow-y-auto overflow-x-hidden ">
        <div
          className={`flex ${!isSidebarClose ? "h-0 opacity-0 " : "h-[60px] opacity-100"
            } transition-all duration-300 w-full bg-[var(--dark-header)] justify-between items-center`}
        >
          <div
            onClick={() => handleToggle()}
            className="cursor-pointer flex h-full justify-center items-center  w-full bg-[var(--secondary)]"
          >
            <div
              onClick={() => handleToggle()}
              className="cursor-pointer flex justify-center items-center bg-[var(--dark-header)] w-10 rounded-full"
            >
              <span>
                <MdKeyboardArrowRight
                  onClick={() => handleToggle()}
                  className="text-white"
                  size={25}
                />
              </span>
            </div>
          </div>
        </div>
        <div
          className={`   ${isSidebarClose ? "h-0 opacity-0 " : "h-[60px] opacity-100"
            }  transition-all duration-700 flex items-center border-b border-[var(--light-header)]  `}
        >
          <div
            onClick={() => {
              navigate("/dashboard");
            }}
            className={`${isSidebarClose ? "hidden" : "flex"
              }  justify-start ml-7 text-white gap-5 margin items-center w-full h-full`}
          >
            <IoHomeOutline size={20} />
            <span className="font-bold text-[17px]"> Home </span>
          </div>
          <div
            onClick={() => handleToggle()}
            className={`${isSidebarClose ? "left-[15px] rotate-180" : "left-[250px]"
              } transition-all duration-[700ms] cursor-pointer fixed  top-[15px]  -translate-x-1/2 flex justify-center items-center bg-[var(--dark-header)] w-10 rounded-full`}
          >
            <span>
              <MdKeyboardArrowLeft className="text-white" size={25} />
            </span>
          </div>
        </div>

        <div>
          {isSidebarClose && (
            <div
              onClick={() => toggleDropdown()}
              className={`w-full flex ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center border-b-[1px] py-4 !border-[var(--light-header)]   text-white text-[20px]`}
            >
              <div
                onClick={() => {
                  navigate("/dashboard");
                }}
                className="flex gap-4"
              >
                <FaHome />{" "}
                <span
                  className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}
                >
                  HOME
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                <MdKeyboardArrowRight size={24} />
              </span>
            </div>
          )}
          {/* {sidebarData?.map((element) => {
            return (
              <div key={element.id}>
                <div
                  onClick={() => toggleDropdown(element.id)}
                  className={`w-full flex ${
                    !isSidebarClose ? "justify-between px-6" : "justify-center"
                  } gap-4 items-center py-4 text-white text-[20px]`}
                >
                  <div className="flex gap-4">
                    <div
                      onClick={() => {
                        if (isSidebarClose) {
                          handleToggle();
                        }
                      }}
                    >
                      {" "}
                      {element?.icon}
                    </div>{" "}
                    <span
                      className={`text-[17px] ${
                        isSidebarClose ? "hidden" : ""
                      }`}
                    >
                      {element?.label}
                    </span>
                  </div>
                  <span
                    className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}
                  >
                    <MdKeyboardArrowDown size={24} />
                  </span>
                </div>

                {element.subItems && openDropdown === element.id && (
                  <div className=" mr-1">
                    {element.subItems.map((subItem) => (
                      <div
                        key={subItem.id}
                        className=" flex w-full justify-center border-b items-center bg-white text-black py-3"
                      >
                        <a href={subItem.link} className="text-[16px]">
                          {subItem.label}
                        </a>
                      </div>
                    ))}
                  </div>
                )}
              </div>
            );
          })} */}

          <div>
            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleGameList();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex cursor-pointer ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex justify-start items-center gap-4">
                <div>
                  {" "}
                  <img
                    src="/assets/dashboard/icon-sport.png"
                    alt=""
                    className="w-8 h-8"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Sports
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!gameList ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] cursor-pointer ${gameList ? "max-h-96" : "max-h-0"
                } overflow-hidden mr-1 bg-[#f5f5f5]`}
            >
              <div
                onClick={() => {
                  window.location.href = `/inplay/${4}`;
                }}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2  items-center   py-3"
              >
                <img
                  src="/mobilesidebarImages/cricket.png"
                  alt=""
                  className="w-5 h-5"
                />
                <div
                  className="text-[18px] text-[#313131]"
                  style={{ fontWeight: "100px" }}
                >
                  <span className=" ">Cricket</span>
                </div>
              </div>
              <div
                onClick={() => {
                  window.location.href = `/inplay/${1}`;
                }}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2 items-center   py-3"
              >
                <img
                  src="/mobilesidebarImages/sbo.png"
                  alt=""
                  className="h-5"
                />
                <div className="text-[18px] ">Football</div>
              </div>
              <div
                onClick={() => {
                  window.location.href = `/inplay/${2}`;
                }}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2 items-center   py-3"
              >
                <img
                  src="/mobilesidebarImages/pinnacle.png"
                  alt=""
                  className="h-5"
                />
                <div className="text-[18px] ">Tennis</div>
              </div>
            </div>

            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleCasinoGames();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex cursor-pointer ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex justify-start items-center gap-4">
                <div>
                  {" "}
                  <img
                    src="/assets/dashboard/icon-casino.png"
                    alt=""
                    className="w-8 h-8"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Casino
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!casinoGamesList ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] cursor-pointer ${casinoGamesList ? "max-h-96" : "max-h-0"
                } overflow-y-auto mr-1 bg-[#f5f5f5]`}
            >
              {providers?.map((game) => (
                <div
                  key={game.eventId}
                  onClick={() => handleProviderClick("casino", game.provider_name)}
                  style={{ padding: "12px 12px 12px 40px" }}
                  className=" flex w-full  border-b gap-2  items-center overflow-y-auto py-3">
                  {/* className={`bg-secondary text-black flex justify-center items-center bg-white md:w-[147px] h-[77px] md:text-[12px] text-[9px] px-2 py-1 rounded outline-none`}> */}
                  <img alt={game.provider_name} className="w-[30px] h-[30px]" src={game.image} />
                  <p className="md:my-0 text-sm my-1 whitespace-nowrap">{game.provider_name}</p>
                </div>
              ))}
              {/* <div
                onClick={() => {
                  window.location.href = `/inplay/${4}`;
                }}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2  items-center   py-3"
              >
                <img
                  src="/mobilesidebarImages/cricket.png"
                  alt=""
                  className="w-5 h-5"
                />
                <div
                  className="text-[18px] text-[#313131]"
                  style={{ fontWeight: "100px" }}
                >
                  <span className=" ">Cricket</span>
                </div>
              </div>
              <div
                onClick={() => {
                  window.location.href = `/inplay/${1}`;
                }}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2 items-center   py-3"
              >
                <img
                  src="/mobilesidebarImages/sbo.png"
                  alt=""
                  className="h-5"
                />
                <div className="text-[18px] ">Football</div>
              </div>
              <div
                onClick={() => {
                  window.location.href = `/inplay/${2}`;
                }}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2 items-center   py-3"
              >
                <img
                  src="/mobilesidebarImages/pinnacle.png"
                  alt=""
                  className="h-5"
                />
                <div className="text-[18px] ">Tennis</div>
              </div> */}
            </div>


            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleSlotGames();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex cursor-pointer ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex justify-start items-center gap-4">
                <div>
                  {" "}
                  <img
                    src="/assets/dashboard/icon-slot.png"
                    alt=""
                    className="w-8 h-8"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Slots
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!slotGamesList ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] cursor-pointer ${slotGamesList ? "max-h-96" : "max-h-0"
                } overflow-hidden mr-1 bg-[#f5f5f5]`}
            >
              <div
                onClick={() => handleProviderClick("slots", "JiLi")}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2  items-center   py-3"
              >
                <img
                  src="/assets/dashboard/provider-awcmjili.png"
                  alt=""
                  className="w-5 h-5"
                />
                <div
                  className="text-[18px] text-[#313131]"
                  style={{ fontWeight: "100px" }}
                >
                  <span className=" ">JiLi</span>
                </div>
              </div>

            </div>

            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleTableGames();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex cursor-pointer ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex justify-start items-center gap-4">
                <div>
                  {" "}
                  <img
                    src="/assets/dashboard/icon-table.png"
                    alt=""
                    className="w-8 h-8"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Table
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!tableGamesList ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] cursor-pointer ${tableGamesList ? "max-h-96" : "max-h-0"
                } overflow-hidden mr-1 bg-[#f5f5f5]`}
            >
              <div
                onClick={() => handleProviderClick("table", "JiLi")}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2  items-center   py-3"
              >
                <img
                  src="/assets/dashboard/provider-awcmjili.png"
                  alt=""
                  className="w-5 h-5"
                />
                <div
                  className="text-[18px] text-[#313131]"
                  style={{ fontWeight: "100px" }}
                >
                  <span className=" ">JiLi</span>
                </div>
              </div>

            </div>

            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleCrashGames();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex cursor-pointer ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex justify-start items-center gap-4">
                <div>
                  {" "}
                  <img
                    src="/assets/dashboard/icon-crash.png"
                    alt=""
                    className="w-8 h-8"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Crash
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!crashGamesList ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] cursor-pointer ${crashGamesList ? "max-h-96" : "max-h-0"
                } overflow-hidden mr-1 bg-[#f5f5f5]`}
            >
              <div
                onClick={() => handleProviderClick("crash", "JiLi")}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2  items-center   py-3"
              >
                <img
                  src="/assets/dashboard/provider-awcmjili.png"
                  alt=""
                  className="w-5 h-5"
                />
                <div
                  className="text-[18px] text-[#313131]"
                  style={{ fontWeight: "100px" }}
                >
                  <span className=" ">JiLi</span>
                </div>
              </div>

            </div>

            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleFishGames();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex cursor-pointer ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex justify-start items-center gap-4">
                <div>
                  {" "}
                  <img
                    src="/assets/dashboard/icon-fish.png"
                    alt=""
                    className="w-8 h-8"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Fishing
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!fishGamesList ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] cursor-pointer ${fishGamesList ? "max-h-96" : "max-h-0"
                } overflow-hidden mr-1 bg-[#f5f5f5]`}
            >
              <div
                onClick={() => handleProviderClick("fishing", "JiLi")}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2  items-center   py-3"
              >
                <img
                  src="/assets/dashboard/provider-awcmjili.png"
                  alt=""
                  className="w-5 h-5"
                />
                <div
                  className="text-[18px] text-[#313131]"
                  style={{ fontWeight: "100px" }}
                >
                  <span className=" ">JiLi</span>
                </div>
              </div>

            </div>

            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleArcadeGames();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex cursor-pointer ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex justify-start items-center gap-4">
                <div>
                  {" "}
                  <img
                    src="/assets/dashboard/icon-arcade.png"
                    alt=""
                    className="w-8 h-8"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Arcade
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!arcadeGamesList ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] cursor-pointer ${arcadeGamesList ? "max-h-96" : "max-h-0"
                } overflow-hidden mr-1 bg-[#f5f5f5]`}
            >
              <div
                onClick={() => handleProviderClick("arcade", "JiLi")}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2  items-center   py-3"
              >
                <img
                  src="/assets/dashboard/provider-awcmjili.png"
                  alt=""
                  className="w-5 h-5"
                />
                <div
                  className="text-[18px] text-[#313131]"
                  style={{ fontWeight: "100px" }}
                >
                  <span className=" ">JiLi</span>
                </div>
              </div>

            </div>

            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleLotteryGames();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex cursor-pointer ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex justify-start items-center gap-4">
                <div>
                  {" "}
                  <img
                    src="/assets/dashboard/icon-lottery.png"
                    alt=""
                    className="w-8 h-8"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Lottery
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!lotteryGamesList ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] cursor-pointer ${lotteryGamesList ? "max-h-96" : "max-h-0"
                } overflow-hidden mr-1 bg-[#f5f5f5]`}
            >
              <div
                onClick={() => handleProviderClick("lottery", "JiLi")}
                style={{ padding: "12px 12px 12px 40px" }}
                className=" flex w-full  border-b gap-2 items-center py-3"
              >
                <img
                  src="/assets/dashboard/provider-awcmjili.png"
                  alt=""
                  className="w-5 h-5"
                />
                <div
                  className="text-[18px] text-[#313131]"
                  style={{ fontWeight: "100px" }}
                >
                  <span className=" ">JiLi</span>
                </div>
              </div>

            </div>


            {/* {isLoading ? (
              <div className="text-[var(--dark-header)]  flex justify-center items-center py-2 animate-spin">
                <AiOutlineLoading3Quarters size={20} />
              </div>
            ) : (
              <div>
                {gamesData?.map((game) => (
                  <>
                    <div
                      key={game.id}
                      onClick={async () => {
                        if (isSidebarClose) {
                          handleToggle();
                        }
                        await handleGetCasinoListByCategory(game.payload);
                        handleCasinoList(game.payload);
                      }}
                      className={`w-full flex ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                        } gap-4 items-center py-4 text-white text-[20px] cursor-pointer`}
                    >
                      <div className="flex gap-4">
                        <div>
                          <img src={game.icon} alt={game.name} className="w-4 h-4" />
                        </div>
                        <span
                          className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""}`}
                        >
                          {game.name}
                        </span>
                      </div>
                      <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                        {casinoList ? <MdKeyboardArrowUp size={24} /> : <MdKeyboardArrowDown size={24} />}
                      </span>
                    </div>
                    <div
                      className={` transition-all duration-[700ms] cursor-pointer overflow-y-auto ${casinoList == game.payload ? "max-h-96" : "max-h-0"
                        } overflow-hidden mr-1 bg-[#f5f5f5]`}
                    >
                      {apiData?.length > 0 ? (
                        apiData.map((item, index) => (
                          <button
                            key={index}
                            onClick={() => (window.location.href = `/iframe-casino-new/${item?.provider_name}/${item?.game_id}`)}
                            className="flex flex-col justify-center items-center border-b px-4 py-2"
                          >
                            <p className="md:my-0 text-xs my-1 text-ellipsis">{item?.game_name}</p>
                          </button>
                        ))
                      ) : (
                        <p className="text-center w-full text-gray-500">No data available. Click a tab to load content.</p>
                      )}
                    </div>
                  </>
                ))}
              </div>
            )} */}


            {/* <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/DC/201206`;
              }}
              className={`w-full flex ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex gap-4">
                <div>
                  {" "}
                  <img
                    src="/mobilesidebarImages/avaitor.png"
                    alt=""
                    className="h-7"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Avaitor
                </span>
              </div>
              <span
                className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                  }`}
              ></span>
            </div>

            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/EZUGI/100001`;
              }}
              className={`w-full flex ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex gap-4">
                <div>
                  {" "}
                  <img
                    src="/mobilesidebarImages/ezugi.png"
                    alt=""
                    className="h-7"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Ezugi
                </span>
              </div>
              <span
                className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                  }`}
              ></span>
            </div>

            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/JiLi/600144`;
              }}
              className={`w-full flex ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px] cursor-pointer`}
            >
              <div className="flex gap-4">
                <div>
                  {" "}
                  <img
                    src="/mobilesidebarImages/color.png"
                    alt=""
                    className="h-7"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] whitespace-nowrap font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Color Pridiction
                </span>
              </div>
              <span
                className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                  }`}
              ></span>
            </div>

            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/EVOLUTION/200213`;
              }}
              className={`w-full flex ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px] cursor-pointer`}
            >
              <div className="flex gap-4">
                <div>
                  {" "}
                  <img
                    src="/mobilesidebarImages/evalution.png"
                    alt=""
                    className="h-7"
                  />

                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Evolution
                </span>
              </div>
              <span
                className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                  }`}
              ></span>
            </div>

            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/RG/900000`;
              }}
              className={`w-full flex ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex gap-4">
                <div>
                  {" "}
                  <img
                    src="/mobilesidebarImages/casino.png"
                    alt=""
                    className="h-7"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] whitespace-nowrap font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Rg Casino
                </span>
              </div>
            </div>

            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/JiLi/600062`;
              }}
              className={`w-full flex ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex gap-4">
                <div>
                  {" "}
                  <img
                    src="/mobilesidebarImages/icon-responsible-gaming.png"
                    alt=""
                    className="h-7"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] whitespace-nowrap font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Ali Baba
                </span>
              </div>
            </div>

            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/JiLi/600120`;
              }}
              className={`w-full flex ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex gap-4">
                <div>
                  {" "}
                  <img
                    src="/mobilesidebarImages/icon-lottery.png"
                    alt=""
                    className="h-7"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] whitespace-nowrap font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Fortune Gemes2
                </span>
              </div>
            </div>

            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/JiLi/600052`;
              }}
              className={`w-full flex ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex gap-4">
                <div>
                  {" "}
                  <img
                    src="/mobilesidebarImages/icon-affiliate.png"
                    alt=""
                    className="h-7"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] whitespace-nowrap font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Golden Empier
                </span>
              </div>
            </div>

            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/JiLi/600029`;
              }}
              className={`w-full flex ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex gap-4">
                <div>
                  {" "}
                  <img
                    src="/mobilesidebarImages/icon-slot.png"
                    alt=""
                    className="h-7"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] whitespace-nowrap font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Crazy777
                </span>
              </div>
            </div>

            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/JiLi/600041`;
              }}
              className={`w-full flex ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex gap-4">
                <div>
                  {" "}
                  <img
                    src="/mobilesidebarImages/icon-responsible-gaming.png"
                    alt=""
                    className="h-7"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] whitespace-nowrap font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Super Ace
                </span>
              </div>
            </div>

            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/JiLi/600037`;
              }}
              className={`w-full flex ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex gap-4">
                <div>
                  {" "}
                  <img
                    src="/mobilesidebarImages/icon-leaderboard.png"
                    alt=""
                    className="h-7"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] whitespace-nowrap font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Golden Banks
                </span>
              </div>
            </div>

            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/JiLi/600046`;
              }}
              className={`w-full flex ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex gap-4">
                <div>
                  {" "}
                  <img
                    src="/mobilesidebarImages/icon-responsible-gaming.png"
                    alt=""
                    className="h-7"
                  />
                </div>{" "}
                <span
                  className={`text-[16px] whitespace-nowrap font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  Boxing King
                </span>
              </div>
            </div> */}

            <div
              //  onClick={() => toggleDropdown(element.id)}
              onClick={() => {
                handleContantUS();
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className={`w-full flex ${!isSidebarClose ? "justify-between px-6" : "justify-center"
                } gap-4 items-center py-4 text-white text-[20px]`}
            >
              <div className="flex gap-2 whitespace-nowrap">
                <div>
                  {" "}
                  <img
                    src="/mobilesidebarImages/icon-talk.png"
                    alt=""
                    className="h-7 "
                  />
                </div>{" "}
                <span
                  className={`text-[16px] font-semibold ${isSidebarClose ? "hidden" : ""
                    }`}
                >
                  ContactUS
                </span>
              </div>
              <span className={`text-[17px] ${isSidebarClose ? "hidden" : ""}`}>
                {!contactUs ? (
                  <MdKeyboardArrowDown size={24} />
                ) : (
                  <MdKeyboardArrowUp size={24} />
                )}
              </span>
            </div>

            <div
              className={` transition-all duration-[700ms] ${contactUs ? "max-h-96" : "max-h-0"
                } overflow-hidden mr-1 bg-[#f5f5f5]`}
            >
              {/* <div className=" flex w-full  border-b gap-2  items-center   py-3" style={{ padding: "12px 12px 12px 40px" }}>
                  <img
                    src="/mobilesidebarImages/icon-customer.png"
                    alt=""
                    className="h-5"
                  />
                  <div className="text-[16px] font-light">
                    Live Chat 24/7
                  </div>
                </div> */}
              <div
                onClick={() => {
                  const telegramLink = defaultSettingData?.find(
                    (data) => data?.key === "site.telegram"
                  )?.value;

                  if (telegramLink) {
                    window.open(telegramLink, "_blank");
                  } else {
                    toast.success("Telegram link not found");
                  }
                }}
                className=" flex w-full  border-b gap-2 items-center  text-black py-3"
                style={{ padding: "12px 12px 12px 40px" }}
              >
                <img
                  src="/mobilesidebarImages/icon-telegram.png"
                  alt=""
                  className="h-5"
                />
                <div className="text-[16px] font-light">Telegram Support</div>
              </div>
              <div
                onClick={() => {
                  const telegramLink = defaultSettingData?.find(
                    (data) => data?.key === "site.facebook"
                  )?.value;

                  if (telegramLink) {
                    window.open(telegramLink, "_blank");
                  } else {
                    toast.success("Telegram link not found");
                  }
                }}
                className=" flex w-full  border-b gap-2 items-center  text-black py-3"
                style={{ padding: "12px 12px 12px 40px" }}
              >
                <img
                  src="/mobilesidebarImages/icon-telegram.png"
                  alt=""
                  className="h-5"
                />
                <div className="text-[16px] font-light">Facebook Support</div>
              </div>
              <div
                onClick={() => {
                  const telegramLink = defaultSettingData?.find(
                    (data) => data?.key === "site.instagram"
                  )?.value;

                  if (telegramLink) {
                    window.open(telegramLink, "_blank");
                  } else {
                    toast.success("Telegram link not found");
                  }
                }}
                className=" flex w-full  border-b gap-2 items-center  text-black py-3"
                style={{ padding: "12px 12px 12px 40px" }}
              >
                <img
                  src="/mobilesidebarImages/icon-telegram.png"
                  alt=""
                  className="h-5"
                />
                <div className="text-[16px] font-light">Instagram Support</div>
              </div>
              {/* <div className=" flex w-full justify-center border-b gap-2 items-center bg-white text-black py-3">
                  <img
                    src="/mobilesidebarImages/sbo.png"
                    alt=""
                    className="h-6"
                  />
                  <a href={""} className="text-[16px] font-light">
                    Telegram Channel
                  </a>
                </div>
                <div className=" flex w-full justify-center border-b gap-2 items-center bg-white text-black py-3">
                  <img
                    src="/mobilesidebarImages/sbo.png"
                    alt=""
                    className="h-6"
                  />
                  <a href={""} className="text-[16px] font-light">
                    Facebook...
                  </a>
                </div>
                <div className=" flex w-full justify-center border-b gap-2 items-center bg-white text-black py-3">
                  <img
                    src="/mobilesidebarImages/sbo.png"
                    alt=""
                    className="h-6"
                  />
                  <a href={""} className="text-[16px] font-light">
                    Support Email
                  </a>
                </div> */}
            </div>

            {/* 
                {element.subItems && openDropdown === element.id && (
                  <div className=" mr-1">
                    {element.subItems.map((subItem) => (
                      <div
                        key={subItem.id}
                        className=" flex w-full justify-center border-b items-center bg-white text-black py-3"
                      >
                        <a href={subItem.link} className="text-[16px]">
                          {subItem.label}
                        </a>
                      </div>
                    ))}
                  </div>
                )} */}
          </div>
        </div>
      </div>

      {isMobile && (
        <div
          className={`fixed inset-0 bg-black bg-opacity-50 backdrop-blur-sm z-20 ${isSidebarClose ? "hidden" : "block"
            }`}
          onClick={handleToggle}
        ></div>
      )}
      <div
        className={`lg:hidden overflow-auto z-[99999] scrollbar-hide fixed top-0 left-0 h-screen bg-white  transform transition-transform duration-300 ${isSidebarClose ? "-translate-x-full" : "translate-x-0"
          }`}
        style={{ width: "190px" }}
      >
        <div className="h-screen bg-white lg:pb-0 pb-14 overflow-y-auto">
          <div className="relative h-screen  ">
            <div
              onClick={() => {
                {
                  navigate("/dashboard");
                }
                handleToggle();
              }}
              className="w-full p-2 text-[15px] gap-3 flex items-center"
            >
              <div className="p-2 rounded-full bg-[var(--primary)]  text-white">
                <FaHome />
              </div>{" "}
              Home
            </div>

            {/* <div className="w-full p-2 text-[15px] gap-3 flex items-center"><div className="p-2 rounded-full bg-[var(--primary)]  text-white"><FaHome/></div> Home</div>
          <div className="w-full p-2 text-[15px] flex items-center gap-3"><div className="p-2 rounded-full bg-[var(--primary)]  text-white"><FaHome/></div> Promotion</div>
          <div className="w-full p-2 text-[15px] flex items-center gap-3"><div className="p-2 rounded-full bg-[var(--primary)]  text-white"><FaHome/></div>Sponsorship</div> */}
            {/* <div className="w-full p-2 text-[15px] flex items-center gap-3 border-b pb-4"><div className="p-2 rounded-full bg-[var(--primary)]  text-white"><FaHome/></div>Leaderboard</div> */}
            <div className="text-[16px] font-semibold pt-4 p-2 pl-4 border-t  ">
              Games
            </div>
            {/* {MOBILE_SIDE_BAR?.games?.map((element, index) => {
              return (
                <div   onClick={() => setMiniSidebar(true)} className="w-full p-2 text-[15px] gap-3 flex items-center text-black">
                  <div className="p-2 rounded-full bg-[var(--primary)]  text-white">
                    {element?.icon}
                  </div>{" "}
                  {element?.label}
                </div>
              );
            })} */}

            <div
              onClick={() => setMiniSidebar(!miniSidebar)}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)] p-1">
                  <img
                    src="/casinoimages/34.png"
                    alt=""
                    className="w-5 h-5"
                  />
                </div>{" "}
                Sports
              </div>
              <IoIosArrowForward className={miniSidebar ? "rotate-180" : ""} />
            </div>


            <div
              onClick={handleCasinoProvider}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)] p-1">
                  <img
                    src="/casinoimages/34.png"
                    alt=""
                    className="w-5 h-5"
                  />
                </div>{" "}
                Casino
              </div>
              <IoIosArrowForward className={casinoProvider ? "rotate-180" : ""} />
            </div>

            <div
              onClick={handleCasino}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)] p-1">
                  <img
                    src="/casinoimages/111.png"
                    alt=""
                    className="w-5 h-5"
                  />
                </div>{" "}
                Live Casino
              </div>
              <IoIosArrowForward className={miniCasino ? "rotate-180" : ""} />
            </div>

            <div
              onClick={handleSlots}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)] p-1.5">
                  <img
                    src="/casinoimages/slot.png"
                    alt=""
                    className="w-5 h-5"
                  />
                </div>{" "}
                Slots
              </div>
              <IoIosArrowForward className={miniSlots ? "rotate-180" : ""} />
            </div>


            <div
              onClick={handleTeenpatti}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)] p-1.5">
                  <img
                    src="/casinoimages/20.png"
                    alt=""
                    className="w-5 h-5"
                  />
                </div>{" "}
                Teenpatti
              </div>
              <IoIosArrowForward className={miniTeenpatti ? "rotate-180" : ""} />
            </div>

            <div
              onClick={handleLucky7}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)] p-1.5">
                  <img
                    src="/casinoimages/27.png"
                    alt=""
                    className="w-5 h-5"
                  />
                </div>{" "}
                Lucky7
              </div>
              <IoIosArrowForward className={miniLucky7 ? "rotate-180" : ""} />
            </div>

            <div
              onClick={handleDragonTiger}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)] p-1.5">
                  <img
                    src="/casinoimages/23.png"
                    alt=""
                    className="w-5 h-5"
                  />
                </div>{" "}
                DragonTiger
              </div>
              <IoIosArrowForward className={miniDragonTiger ? "rotate-180" : ""} />
            </div>

            <div
              onClick={handleBaccarat}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)] p-1.5">
                  <img
                    src="/casinoimages/22.png"
                    alt=""
                    className="w-5 h-5"
                  />
                </div>{" "}
                Baccarat
              </div>
              <IoIosArrowForward className={miniBaccarat ? "rotate-180" : ""} />
            </div>

            <div
              onClick={handleAndarBahar}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)]  p-1.5">
                  <img
                    src="/casinoimages/26.png"
                    alt=""
                    className="w-5 h-5"
                  />
                </div>{" "}
                Andar Bahar
              </div>
              <IoIosArrowForward className={miniAndarBahar ? "rotate-180" : ""} />
            </div>


            <div
              onClick={handlePoker}
              className="w-full p-2 text-[15px] gap-3 flex justify-between items-center text-black"
            >
              <div className="flex items-center gap-3">
                <div className="rounded-full bg-[var(--primary)] p-1.5">
                  <img
                    src="/casinoimages/21.png"
                    alt=""
                    className="w-5 h-5"
                  />
                </div>{" "}
                Poker
              </div>
              <IoIosArrowForward className={miniPoker ? "rotate-180" : ""} />
            </div>

            {/* <div className="text-[16px] font-semibold pt-6 p-2 pl-4 border-t mt-2 ">
              Casino
            </div> */}
            {/* <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/DC/201206`;
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
            >
              <div className="p-0.5 rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/avaitor.png"
                  alt=""
                  className="h-7"
                />
              </div>{" "}
              Avaitor
            </div>

            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/EZUGI/100001`;
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
            >
              <div className="p-0.5 rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/ezugi.png"
                  alt=""
                  className="h-7"
                />
              </div>{" "}
              Ezugi
            </div>
            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/EVOLUTION/200213`;

                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
            >
              <div className=" p-0.5 rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/evalution.png"
                  alt=""
                  className="h-7"
                />
              </div>{" "}
              Evalution
            </div>
            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/RG/900000`;
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
            >
              <div className="p-0.5  rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/casino.png"
                  alt=""
                  className="h-7"
                />
              </div>{" "}
              Rg Casino
            </div>

            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/JiLi/600144`;
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className="w-full p-2 whitespace-nowrap text-[15px] gap-3 flex items-center text-black"
            >
              <div className="p-0.5 rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/color.png"
                  alt=""
                  className="h-7"
                />
              </div>{" "}
              Color Pridiction
            </div>
            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/JiLi/600062`;
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className="w-full p-2 whitespace-nowrap text-[15px] gap-3 flex items-center text-black"
            >
              <div className="p-0.5 rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/color.png"
                  alt=""
                  className="h-7"
                />
              </div>{" "}
              Ali Baba
            </div>

            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/JiLi/600120`;
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className="w-full p-2 whitespace-nowrap text-[15px] gap-3 flex items-center text-black"
            >
              <div className="p-0.5 rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/icon-lottery.png"
                  alt=""
                  className="h-7"
                />
              </div>{" "}
              Fortune Gemes2
            </div>

            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/JiLi/600052`;
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className="w-full p-2 whitespace-nowrap text-[15px] gap-3 flex items-center text-black"
            >
              <div className="p-0.5 rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/icon-affiliate.png"
                  alt=""
                  className="h-7"
                />
              </div>{" "}
              Golden Empier
            </div>

            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/JiLi/600029`;
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className="w-full p-2 whitespace-nowrap text-[15px] gap-3 flex items-center text-black"
            >
              <div className="p-0.5 rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/icon-slot.png"
                  alt=""
                  className="h-7"
                />
              </div>{" "}
              Crazy777
            </div>

            <div
              onClick={() => {
                window.location.href = `/iframe-casino-new/JiLi/600041`;
                if (isSidebarClose) {
                  handleToggle();
                }
              }}
              className="w-full p-2 whitespace-nowrap text-[15px] gap-3 flex items-center text-black"
            >
              <div className="p-0.5 rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/icon-responsible-gaming.png"
                  alt=""
                  className="h-7"
                />
              </div>{" "}
              Super Ace
            </div> */}

            <div className="text-[16px] font-semibold pt-6 p-2 pl-4 border-t mt-2 ">
              Others
            </div>

            {/* {MOBILE_SIDE_BAR?.others?.map((element, index) => {
              return (
                <div
                  className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
                  onClick={() => {
                    toggleDropdown(element?.id);
                  }}
                >
                  <div className="p-2 rounded-full bg-[var(--primary)]  text-white">
                    {element?.icon}
                  </div>{" "}
                  {element?.name}
                </div>
              );
            })} */}

            {/* <div
              className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
              onClick={() => {
                toggleDropdown();
              }}
            >
              <div className=" rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/icon-talk.png"
                  alt=""
                  className="h-8"
                />
              </div>{" "}
              24/7 Live Chat
            </div> */}
            <div
              className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
              onClick={() => {
                const telegramLink = defaultSettingData?.find(
                  (data) => data?.key === "site.telegram"
                )?.value;

                if (telegramLink) {
                  window.open(telegramLink, "_blank");
                } else {
                  toast.success("Telegram link not found");
                }
              }}
            >
              <div className=" rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/mobiletelegram.png"
                  alt=""
                  className="h-8"
                />
              </div>{" "}
              Telegram Support
            </div>
            <div
              className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
              onClick={() => {
                const telegramLink = defaultSettingData?.find(
                  (data) => data?.key === "site.facebook"
                )?.value;

                if (telegramLink) {
                  window.open(telegramLink, "_blank");
                } else {
                  toast.success("Telegram link not found");
                }
              }}
            >
              <div className=" rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/icon-talk.png"
                  alt=""
                  className="h-8"
                />
              </div>{" "}
              Facebook Support
            </div>
            <div
              className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
              onClick={() => {
                const telegramLink = defaultSettingData?.find(
                  (data) => data?.key === "site.instagram"
                )?.value;

                if (telegramLink) {
                  window.open(telegramLink, "_blank");
                } else {
                  toast.success("Telegram link not found");
                }
              }}
            >
              <div className=" rounded-full bg-[var(--primary)]  text-white">
                <img
                  src="/mobilesidebarImages/icon-faq.png"
                  alt=""
                  className="h-8"
                />
              </div>{" "}
              Instagram
            </div>
            {/* <div
              className="w-full p-2 text-[15px] gap-3 flex items-center text-black"
              onClick={() => {
                toggleDropdown(element?.id);
              }}
            >
              <div className=" rounded-full bg-[var(--primary)]  text-white">
              <img src="/mobilesidebarImages/mobiletelegram.png" alt=""  className="h-9"/>
              </div>{" "}
              Responsible Gaming
            </div> */}
          </div>
        </div>
      </div>
    </>
  );
};

export default AppSidebar;


export const gamesData = [
  {
    id: 5001,
    name: "Live Casino",
    payload: "live-casino",
    icon: "/casinoimages/111.png"
  },
  {
    id: 5002,
    name: "Slots",
    payload: "JiLi",
    icon: "/casinoimages/slot.png"
  },
  {
    id: 5003,
    name: "teen-patti",
    payload: "teen-patti",
    icon: "/casinoimages/20.png"
  },
  {
    id: 5004,
    name: "lucky7",
    payload: "lucky7",
    icon: "/casinoimages/27.png"
  },
  {
    id: 5005,
    name: "dragon-tiger",
    payload: "dragon-tiger",
    icon: "/casinoimages/23.png"
  },
  {
    id: 5006,
    name: "baccarat",
    payload: "baccarat",
    icon: "/casinoimages/22.png"
  },
  {
    id: 5007,
    name: "andar-bahar",
    payload: "andar-bahar",
    icon: "/casinoimages/26.png"
  },
  {
    id: 5008,
    name: "poker",
    payload: "poker",
    icon: "/casinoimages/21.png"
  }
];